#include <iostream>
#include <vector>

using namespace std;

using L = long long;
using I128 = __int128; 

struct Pomeraj {
    L x, y;
    int index;
};

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    
    int n;
    if (!(cin >> n)) return 0;

    vector<Pomeraj> pomeraji(n);
    for (int i = 0; i < n; ++i) {
        cin >> pomeraji[i].x >> pomeraji[i].y;
        pomeraji[i].index = i + 1;
    }

    I128 X = 0;
    I128 Y = 0;
    vector<int> izabrani_indeksi;

    for (int i = 0; i < n; ++i) {
        L xi = pomeraji[i].x;
        L yi = pomeraji[i].y;

        I128 projekcija_X = X * xi;
        I128 projekcija_Y = Y * yi;
        I128 suma_projekcija = projekcija_X + projekcija_Y;
        I128 dupli_zbir = suma_projekcija * 2;
        I128 duzina_pomeraja_sq = (I128)xi * xi + (I128)yi * yi;
        I128 razlika = dupli_zbir + duzina_pomeraja_sq;
        
        if (razlika > 0) {
            X += xi;
            Y += yi;
            izabrani_indeksi.push_back(pomeraji[i].index);
        }
    }

    cout << izabrani_indeksi.size() << endl;
    for (int i = 0; i < izabrani_indeksi.size(); ++i) {
        cout << izabrani_indeksi[i] << (i == izabrani_indeksi.size() - 1 ? "" : " ");
    }
    cout << endl;
    
    return 0;
}